/*
 * Decompiled with CFR 0.152.
 */
package fluke.worleycaves.util;

import fluke.worleycaves.util.FastNoise;

public class WorleyUtil {
    private int m_seed = 1337;
    private float m_frequency = 0.01f;
    private static final int X_PRIME = 1619;
    private static final int Y_PRIME = 31337;
    private static final int Z_PRIME = 6971;
    private static final Float3[] CELL_3D = new Float3[]{new Float3(0.14537874f, -0.41497818f, -0.09569818f), new Float3(-0.012428297f, -0.14579184f, -0.42554703f), new Float3(0.28779796f, -0.026064834f, -0.34495357f), new Float3(-0.07732987f, 0.23770943f, 0.37418488f), new Float3(0.11072059f, -0.3552302f, -0.25308585f), new Float3(0.27552092f, 0.26405212f, -0.23846321f), new Float3(0.29416895f, 0.15260646f, 0.30442718f), new Float3(0.4000921f, -0.20340563f, 0.0324415f), new Float3(-0.16973041f, 0.39708647f, -0.12654613f), new Float3(-0.14832245f, -0.38596946f, 0.17756131f), new Float3(0.2623597f, -0.2354853f, 0.27966776f), new Float3(-0.2709003f, 0.3505271f, -0.07901747f), new Float3(-0.035165507f, 0.38852343f, 0.22430544f), new Float3(-0.12677127f, 0.1920044f, 0.38673422f), new Float3(0.02952022f, 0.44096857f, 0.084706925f), new Float3(-0.28068542f, -0.26699677f, 0.22897254f), new Float3(-0.17115955f, 0.21411856f, 0.35687205f), new Float3(0.21132272f, 0.39024058f, -0.074531786f), new Float3(-0.10243528f, 0.21280442f, -0.38304216f), new Float3(-0.330425f, -0.15669867f, 0.26223055f), new Float3(0.20911114f, 0.31332782f, -0.24616706f), new Float3(0.34467816f, -0.19442405f, -0.21423413f), new Float3(0.19844781f, -0.32143423f, -0.24453732f), new Float3(-0.29290086f, 0.22629151f, 0.2559321f), new Float3(-0.16173328f, 0.00631477f, -0.41988388f), new Float3(-0.35820603f, -0.14830318f, -0.2284614f), new Float3(-0.18520673f, -0.34541193f, -0.2211087f), new Float3(0.3046301f, 0.10263104f, 0.3149085f), new Float3(-0.038167685f, -0.25517663f, -0.3686843f), new Float3(-0.40849522f, 0.18059509f, 0.05492789f), new Float3(-0.026874434f, -0.27497414f, 0.35519993f), new Float3(-0.038010985f, 0.3277859f, 0.30596006f), new Float3(0.23711208f, 0.29003868f, -0.2493099f), new Float3(0.44476604f, 0.039469305f, 0.05590469f), new Float3(0.019851472f, -0.015031833f, -0.44931054f), new Float3(0.4274339f, 0.033459943f, -0.1366773f), new Float3(-0.20729886f, 0.28714147f, -0.27762738f), new Float3(-0.3791241f, 0.12811777f, 0.205793f), new Float3(-0.20987213f, -0.10070873f, -0.38511226f), new Float3(0.01582799f, 0.42638946f, 0.14297384f), new Float3(-0.18881294f, -0.31609967f, -0.2587096f), new Float3(0.1612989f, -0.19748051f, -0.3707885f), new Float3(-0.08974491f, 0.22914875f, -0.37674487f), new Float3(0.07041229f, 0.41502303f, -0.15905343f), new Float3(-0.108292565f, -0.15860616f, 0.40696046f), new Float3(0.24741006f, -0.33094147f, 0.17823021f), new Float3(-0.10688367f, -0.27016446f, -0.34363797f), new Float3(0.23964521f, 0.068036005f, -0.37475494f), new Float3(-0.30638862f, 0.25974283f, 0.2028785f), new Float3(0.15933429f, -0.311435f, -0.2830562f), new Float3(0.27096906f, 0.14126487f, -0.33033317f), new Float3(-0.15197805f, 0.3623355f, 0.2193528f), new Float3(0.16997737f, 0.3456013f, 0.232739f), new Float3(-0.19861557f, 0.38362765f, -0.12602258f), new Float3(-0.18874821f, -0.2050155f, -0.35333094f), new Float3(0.26591033f, 0.3015631f, -0.20211722f), new Float3(-0.08838976f, -0.42888197f, -0.1036702f), new Float3(-0.042018693f, 0.30995926f, 0.3235115f), new Float3(-0.32303345f, 0.20154992f, -0.23984788f), new Float3(0.2612721f, 0.27598545f, -0.24097495f), new Float3(0.38571304f, 0.21934603f, 0.074918374f), new Float3(0.07654968f, 0.37217322f, 0.24109592f), new Float3(0.4317039f, -0.02577753f, 0.12436751f), new Float3(-0.28904364f, -0.341818f, -0.045980845f), new Float3(-0.22019476f, 0.38302338f, -0.085483104f), new Float3(0.41613227f, -0.16696343f, -0.03817252f), new Float3(0.22047181f, 0.02654239f, -0.391392f), new Float3(-0.10403074f, 0.38900796f, -0.2008741f), new Float3(-0.14321226f, 0.3716144f, -0.20950656f), new Float3(0.39783806f, -0.062066693f, 0.20092937f), new Float3(-0.25992745f, 0.2616725f, -0.25780848f), new Float3(0.40326184f, -0.11245936f, 0.1650236f), new Float3(-0.0895347f, -0.30482447f, 0.31869355f), new Float3(0.1189372f, -0.2875222f, 0.3250922f), new Float3(0.02167047f, -0.032846306f, -0.44827616f), new Float3(-0.34113437f, 0.2500031f, 0.15370683f), new Float3(0.31629646f, 0.3082064f, -0.08640228f), new Float3(0.2355139f, -0.34393343f, -0.16953762f), new Float3(-0.028745415f, -0.39559332f, 0.21255504f), new Float3(-0.24614552f, 0.020202823f, -0.3761705f), new Float3(0.042080294f, -0.44704396f, 0.029680781f), new Float3(0.27274588f, 0.22884719f, -0.27520657f), new Float3(-0.13475229f, -0.027208483f, -0.42848748f), new Float3(0.38296244f, 0.123193145f, -0.20165123f), new Float3(-0.35476136f, 0.12717022f, 0.24591078f), new Float3(0.23057902f, 0.30638957f, 0.23549682f), new Float3(-0.08323845f, -0.19222452f, 0.39827263f), new Float3(0.2993663f, -0.2619918f, -0.21033332f), new Float3(-0.21548657f, 0.27067477f, 0.2877511f), new Float3(0.016833553f, -0.26806557f, -0.36105052f), new Float3(0.052404292f, 0.4335128f, -0.108721785f), new Float3(0.0094010485f, -0.44728905f, 0.0484161f), new Float3(0.34656888f, 0.011419145f, -0.28680938f), new Float3(-0.3706868f, -0.25511044f, 0.0031566927f), new Float3(0.274117f, 0.21399724f, -0.28559598f), new Float3(0.06413434f, 0.17087185f, 0.41132662f), new Float3(-0.38818797f, -0.039732803f, -0.22412363f), new Float3(0.064194694f, -0.28036824f, 0.3460819f), new Float3(-0.19861208f, -0.33911735f, 0.21920918f), new Float3(-0.20320301f, -0.38716415f, 0.10636004f), new Float3(-0.13897364f, -0.27759016f, -0.32577604f), new Float3(-0.065556414f, 0.34225327f, -0.28471926f), new Float3(-0.25292465f, -0.2904228f, 0.23277397f), new Float3(0.14444765f, 0.1069184f, 0.41255707f), new Float3(-0.364378f, -0.24471f, -0.09922543f), new Float3(0.42861426f, -0.13584961f, -0.018295068f), new Float3(0.16587292f, -0.31368086f, -0.27674988f), new Float3(0.22196105f, -0.365814f, 0.13933203f), new Float3(0.043229405f, -0.38327307f, 0.23180372f), new Float3(-0.0848127f, -0.44048697f, -0.035749655f), new Float3(0.18220821f, -0.39532593f, 0.1140946f), new Float3(-0.32693234f, 0.30365425f, 0.05838957f), new Float3(-0.40804854f, 0.042278584f, -0.18495652f), new Float3(0.26760253f, -0.012996716f, 0.36155218f), new Float3(0.30248925f, -0.10099903f, -0.3174893f), new Float3(0.1448494f, 0.42592168f, -0.01045808f), new Float3(0.41984022f, 0.0806232f, 0.14047809f), new Float3(-0.30088723f, -0.3330409f, -0.032413557f), new Float3(0.36393103f, -0.12912844f, -0.23104121f), new Float3(0.32958066f, 0.018417599f, -0.30583882f), new Float3(0.27762595f, -0.2974929f, -0.19215047f), new Float3(0.41490006f, -0.14479318f, -0.096916884f), new Float3(0.14501671f, -0.039899293f, 0.4241205f), new Float3(0.092990234f, -0.29973218f, -0.32251117f), new Float3(0.10289071f, -0.36126688f, 0.24778973f), new Float3(0.26830572f, -0.070760414f, -0.35426685f), new Float3(-0.4227307f, -0.07933162f, -0.13230732f), new Float3(-0.17812248f, 0.18068571f, -0.3716518f), new Float3(0.43907887f, -0.028418485f, -0.094351165f), new Float3(0.29725835f, 0.23827997f, -0.23949975f), new Float3(-0.17070028f, 0.22158457f, 0.3525077f), new Float3(0.38066867f, 0.14718525f, -0.18954648f), new Float3(-0.17514457f, -0.2748879f, 0.31025964f), new Float3(-0.22272375f, -0.23167789f, 0.31499124f), new Float3(0.13696331f, 0.13413431f, -0.40712288f), new Float3(-0.35295033f, -0.24728934f, -0.1295146f), new Float3(-0.25907442f, -0.29855776f, -0.21504351f), new Float3(-0.37840194f, 0.21998167f, -0.10449899f), new Float3(-0.056358058f, 0.14857374f, 0.42101023f), new Float3(0.32514286f, 0.09666047f, -0.29570064f), new Float3(-0.41909957f, 0.14067514f, -0.08405979f), new Float3(-0.3253151f, -0.3080335f, -0.042254567f), new Float3(0.2857946f, -0.05796152f, 0.34272718f), new Float3(-0.2733604f, 0.1973771f, -0.29802075f), new Float3(0.21900366f, 0.24100378f, -0.31057137f), new Float3(0.31827673f, -0.27134296f, 0.16605099f), new Float3(-0.03222023f, -0.33311614f, -0.30082467f), new Float3(-0.30877802f, 0.19927941f, -0.25969952f), new Float3(-0.06487612f, -0.4311323f, 0.11142734f), new Float3(0.39211714f, -0.06294284f, -0.2116184f), new Float3(-0.16064045f, -0.3589281f, -0.21878128f), new Float3(-0.037677713f, -0.22903514f, 0.3855169f), new Float3(0.13948669f, -0.3602214f, 0.23083329f), new Float3(-0.4345094f, 0.005751117f, 0.11691243f), new Float3(-0.10446375f, 0.41681284f, -0.13362028f), new Float3(0.26587275f, 0.25519434f, 0.2582393f), new Float3(0.2051462f, 0.19753908f, 0.3484155f), new Float3(-0.26608557f, 0.23483312f, 0.2766801f), new Float3(0.07849406f, -0.33003464f, -0.29566166f), new Float3(-0.21606864f, 0.053764515f, -0.39105463f), new Float3(-0.18577918f, 0.21484992f, 0.34903526f), new Float3(0.024924217f, -0.32299542f, -0.31233433f), new Float3(-0.12016783f, 0.40172666f, 0.16332598f), new Float3(-0.021600846f, -0.06885389f, 0.44417626f), new Float3(0.259767f, 0.30963007f, 0.19786438f), new Float3(-0.16115539f, -0.09823036f, 0.40850917f), new Float3(-0.32788968f, 0.14616702f, 0.27133662f), new Float3(0.2822735f, 0.03754421f, -0.3484424f), new Float3(0.03169341f, 0.34740525f, -0.28426242f), new Float3(0.22026137f, -0.3460788f, -0.18497133f), new Float3(0.2933396f, 0.30319735f, 0.15659896f), new Float3(-0.3194923f, 0.24537522f, -0.20053846f), new Float3(-0.3441586f, -0.16988562f, -0.23493347f), new Float3(0.27036458f, -0.35742772f, 0.040600598f), new Float3(0.2298569f, 0.37441564f, 0.09735889f), new Float3(0.09326604f, -0.31701088f, 0.30545956f), new Float3(-0.11161653f, -0.29850188f, 0.31770802f), new Float3(0.21729073f, -0.34600052f, -0.1885958f), new Float3(0.19913395f, 0.38203415f, -0.12998295f), new Float3(-0.054191817f, -0.21031451f, 0.3941206f), new Float3(0.08871337f, 0.20121174f, 0.39261147f), new Float3(0.27876732f, 0.35054046f, 0.04370535f), new Float3(-0.32216644f, 0.30672136f, 0.06804997f), new Float3(-0.42773664f, 0.13206677f, 0.045822866f), new Float3(0.24013188f, -0.1612516f, 0.34472394f), new Float3(0.1448608f, -0.2387819f, 0.35284352f), new Float3(-0.38370657f, -0.22063984f, 0.081162356f), new Float3(-0.4382628f, -0.09082753f, -0.046648555f), new Float3(-0.37728354f, 0.05445141f, 0.23914887f), new Float3(0.12595794f, 0.34839457f, 0.25545222f), new Float3(-0.14062855f, -0.27087736f, -0.33067968f), new Float3(-0.15806945f, 0.4162932f, -0.06491554f), new Float3(0.2477612f, -0.29278675f, -0.23535146f), new Float3(0.29161328f, 0.33125353f, 0.08793625f), new Float3(0.073652655f, -0.16661598f, 0.4114783f), new Float3(-0.26126525f, -0.24222377f, 0.27489653f), new Float3(-0.3721862f, 0.25279015f, 0.008634938f), new Float3(-0.36911917f, -0.25528118f, 0.032902323f), new Float3(0.22784418f, -0.3358365f, 0.1944245f), new Float3(0.36339816f, -0.23101902f, 0.13065979f), new Float3(-0.3042315f, -0.26984522f, 0.19268309f), new Float3(-0.3199312f, 0.31633255f, -0.008816978f), new Float3(0.28748524f, 0.16422755f, -0.30476475f), new Float3(-0.14510968f, 0.3277541f, -0.27206695f), new Float3(0.3220091f, 0.05113441f, 0.31015387f), new Float3(-0.12474009f, -0.043336052f, -0.4301882f), new Float3(-0.2829556f, -0.30561906f, -0.1703911f), new Float3(0.10693844f, 0.34910247f, -0.26304305f), new Float3(-0.14206612f, -0.30553767f, -0.29826826f), new Float3(-0.25054833f, 0.31564668f, -0.20023163f), new Float3(0.3265788f, 0.18712291f, 0.24664004f), new Float3(0.07646097f, -0.30266908f, 0.3241067f), new Float3(0.34517714f, 0.27571207f, -0.085648015f), new Float3(0.29813796f, 0.2852657f, 0.17954728f), new Float3(0.28122503f, 0.34667164f, 0.056844097f), new Float3(0.43903455f, -0.0979043f, -0.012783354f), new Float3(0.21483733f, 0.18501726f, 0.3494475f), new Float3(0.2595421f, -0.07946825f, 0.3589188f), new Float3(0.3182823f, -0.30735552f, -0.08203022f), new Float3(-0.40898594f, -0.046477184f, 0.18185264f), new Float3(-0.2826749f, 0.07417482f, 0.34218854f), new Float3(0.34838647f, 0.22544225f, -0.1740766f), new Float3(-0.32264152f, -0.14205854f, -0.27968165f), new Float3(0.4330735f, -0.11886856f, -0.028594075f), new Float3(-0.08717822f, -0.39098963f, -0.20500502f), new Float3(-0.21496783f, 0.3939974f, -0.032478984f), new Float3(-0.26873308f, 0.32268628f, -0.16172849f), new Float3(0.2105665f, -0.1961317f, -0.34596834f), new Float3(0.43618459f, -0.11055175f, 0.0046166084f), new Float3(0.053333335f, -0.3136395f, -0.31825432f), new Float3(-0.059862167f, 0.13610291f, -0.4247264f), new Float3(0.36649886f, 0.2550543f, -0.055909745f), new Float3(-0.23410155f, -0.18240573f, 0.33826706f), new Float3(-0.047309477f, -0.422215f, -0.14831145f), new Float3(-0.23915662f, -0.25776964f, -0.28081828f), new Float3(-0.1242081f, 0.42569533f, -0.07652336f), new Float3(0.26148328f, -0.36501792f, 0.02980623f), new Float3(-0.27287948f, -0.3499629f, 0.07458405f), new Float3(0.0078929f, -0.16727713f, 0.41767937f), new Float3(-0.017303303f, 0.29784867f, -0.33687797f), new Float3(0.20548357f, -0.32526004f, -0.23341466f), new Float3(-0.3231995f, 0.15642828f, -0.2712421f), new Float3(-0.2669546f, 0.25993437f, -0.2523279f), new Float3(-0.05554373f, 0.3170814f, -0.3144428f), new Float3(-0.20839357f, -0.31092283f, -0.24979813f), new Float3(0.06989323f, -0.31561416f, 0.31305373f), new Float3(0.38475662f, -0.16053091f, -0.16938764f), new Float3(-0.30262154f, -0.30015376f, -0.14431883f), new Float3(0.34507355f, 0.0861152f, 0.27569625f), new Float3(0.18144733f, -0.27887824f, -0.3029914f), new Float3(-0.038550105f, 0.09795111f, 0.4375151f), new Float3(0.35336703f, 0.26657528f, 0.08105161f), new Float3(-0.007945601f, 0.14035943f, -0.42747644f), new Float3(0.40630993f, -0.14917682f, -0.123119935f), new Float3(-0.20167735f, 0.008816271f, -0.40217972f), new Float3(-0.075270556f, -0.42564347f, -0.12514779f)};

    public void SetFrequency(float frequency) {
        this.m_frequency = frequency;
    }

    private static int Hash3D(int seed, int x, int y, int z) {
        int hash = seed;
        hash ^= x;
        hash ^= y;
        hash ^= z;
        hash = hash * hash * hash * 60493;
        hash = hash >> 13 ^ hash;
        return hash;
    }

    public float SingleCellular3Edge(float x, float y, float z) {
        int xr = FastNoise.FastFloor(x *= this.m_frequency) - 1;
        int yr = FastNoise.FastFloor(y *= this.m_frequency) - 1;
        int zr = FastNoise.FastFloor(z *= this.m_frequency) - 1;
        int xrPrime = xr * 1619;
        int yrPrime = yr * 31337;
        int zrPrime = zr * 6971;
        float distance1 = 999999.0f;
        float distance2 = 999999.0f;
        float distance3 = 999999.0f;
        int xp = xrPrime;
        int yp = yrPrime;
        int zp = zrPrime;
        for (int xi = 0; xi < 3; ++xi) {
            yp = yrPrime;
            for (int yi = 0; yi < 3; ++yi) {
                zp = zrPrime;
                for (int zi = 0; zi < 3; ++zi) {
                    Float3 vec = CELL_3D[WorleyUtil.Hash3D(this.m_seed, xp, yp, zp) & 0xFF];
                    float vecX = (float)(xr + xi) + vec.x + 0.5f - x;
                    float vecY = (float)(yr + yi) + vec.y + 0.5f - y;
                    float vecZ = (float)(zr + zi) + vec.z + 0.5f - z;
                    float newDistance = vecX * vecX + vecY * vecY + vecZ * vecZ;
                    if (newDistance < distance1) {
                        distance3 = distance2;
                        distance2 = distance1;
                        distance1 = newDistance;
                    } else if (newDistance < distance2) {
                        distance3 = distance2;
                        distance2 = newDistance;
                    } else if (newDistance < distance3) {
                        distance3 = newDistance;
                    }
                    zp += 6971;
                }
                yp += 31337;
            }
            xp += 1619;
        }
        return distance1 / distance3 - 1.0f;
    }

    private static class Float3 {
        public final float x;
        public final float y;
        public final float z;

        public Float3(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

